#This file and specified assets in 'README.txt' are under the 2024 MIT license and subject to it's terms.

#Add these features:
#-Fix image sizes for checkmarks in Windows
#-Add ffmpeg dependency
#-Fix windows compile(pyinstaller) cmd window open

import threading
import pygame # For app behaviour
from tkinter import Tk # For pasting
import yt_dlp # For YouTube downloading
import os

# Initialize pygame
pygame.init()

# Set up the screen
WIDTH, HEIGHT = 400, 600
screen = pygame.display.set_mode((WIDTH, HEIGHT))
pygame.display.set_caption("Video Downloader")

# Load icon
icon_path = os.path.join("assets", "video downloader.svg")
icon = pygame.image.load(icon_path)
# Set icon
pygame.display.set_icon(icon)

# Load checkmark
checkmark_path = os.path.join("assets", "checkmark.svg")
checkmark_loaded = pygame.image.load(checkmark_path)
checkmark = pygame.transform.scale(checkmark_loaded, (30, 30))

# Set up fonts
font = pygame.font.Font(os.path.join("assets", "Roboto-Medium.ttf"), 36)
small_font = pygame.font.Font(os.path.join("assets", "Roboto-Medium.ttf"), 25)
tiny_font = pygame.font.Font(os.path.join("assets", "Roboto-Medium.ttf"), 18)

# Set up colors
WHITE = (255, 255, 255)
LIGHT_GREY = (200, 200, 200)
BLACK = (0, 0, 0)
CALM_BLUE = (17, 61, 193)
GREEN = (9, 104, 18)
RED = (255, 0, 0)

# Set up variables
input_text = ""
saved_text = ""
input_box_active = False
inputBoxHeight = 50
submitButtonY = 110
background_colour = LIGHT_GREY

# Options
# just audio
option1 = False
# best quality
option2 = True

# Constants for backspace repeating
BACKSPACE_DELAY = 500  # milliseconds
BACKSPACE_REPEAT_INTERVAL = 50  # milliseconds
backspace_pressed_time = 0
backspace_repeat_time = 0


def display_text(text, x, y, width):
    line = ""
    lines = []
    #wrap text if line is wider than container width - 30
    for char in text:
        line += char
        line_surface = font.render(line, True, BLACK, WHITE)
        line_rect = line_surface.get_rect(midleft=(x, y))
        if line_rect.width >= width - 40:
            lines.append(line)
            line = ""
    lines.append(line)
    #Display and add a y-offset to lines
    y_offset = 0
    for line in lines:
        line_surface = font.render(line, True, BLACK, WHITE)
        line_rect = line_surface.get_rect(midleft=(x, y + y_offset))
        screen.blit(line_surface, line_rect)
        y_offset += 50
    return lines

def draw_options_checkboxes():
    pygame.draw.rect(screen, BLACK, (170, submitButtonY + 60, 20, 20), 1)
    pygame.draw.rect(screen, BLACK, (210, submitButtonY + 60, 20, 20), 1)
    if option1 == True:
        screen.blit(checkmark, (165, submitButtonY + 55))
    if option2 == True:
        screen.blit(checkmark, (205, submitButtonY + 55))

    # Descriptions
    text_surface = tiny_font.render("Audio", True, BLACK, background_colour)
    text_rect = text_surface.get_rect(midleft=(110, submitButtonY + 70))
    screen.blit(text_surface, text_rect)

    text_surface = tiny_font.render("Best quality", True, BLACK, background_colour)
    text_rect = text_surface.get_rect(midleft=(240, submitButtonY + 70))
    screen.blit(text_surface, text_rect)

def change_input_box_height(text, x, y, width):
    line = ""
    lines = []
    #wrap text if line is wider than container width - 30
    for char in text:
        line += char
        line_surface = font.render(line, True, BLACK, WHITE)
        line_rect = line_surface.get_rect(midleft=(x, y))
        if line_rect.width >= width - 30:
            lines.append(line)
            line = ""
    lines.append(line)
    input_box_height = 50 * len(lines)
    submit_button_y = 60 + (50 * len(lines))
    return input_box_height, submit_button_y

# Function to draw the input box
def draw_input_box():
    pygame.draw.rect(screen, WHITE, (50, 50, 300, inputBoxHeight))
    pygame.draw.rect(screen, BLACK, (50, 50, 300, inputBoxHeight), 2)

# Function to draw the button
def draw_button():
    text = "Submit"
    pygame.draw.rect(screen, WHITE, (150, submitButtonY, 100, 50), 0, 10)
    pygame.draw.rect(screen, CALM_BLUE, (150, submitButtonY, 100, 50), 4, 10)
    line_surface = small_font.render(text, True, BLACK, WHITE)
    line_rect = line_surface.get_rect(midleft=(160, submitButtonY + 25))
    screen.blit(line_surface, line_rect)

def paste_from_clipboard():
    root = Tk()
    root.withdraw()  # Hide the tkinter window
    text = root.clipboard_get()
    root.destroy()
    return text

def get_default_download_location():
    # Get the user's home directory
    home_dir = os.path.expanduser("~")
    
    # Check the operating system
    if os.name == 'nt':  # Windows
        default_download_location = os.path.join(home_dir, 'Downloads')
    elif os.name == 'posix':  # Linux, macOS, Unix
        default_download_location = os.path.join(home_dir, 'Downloads')
    else:
        # Default to home directory if the OS is not recognized
        default_download_location = home_dir
    
    return default_download_location

def download():
    global background_colour

    download_folder = get_default_download_location()

    if option1 and not option2:
        youtube_download_options = {
            'postprocessors': [{
                'key': 'FFmpegExtractAudio',
                'preferredcodec': 'mp3', # you can change the codec to 'wav', 'm4a', etc. as needed
                'preferredquality': 'best', # you can change the audio quality as needed
            }],
            'outtmpl': os.path.join(download_folder, "Video Downloader", '%(title)s.%(ext)s')
        }
    elif option2 and not option1:
        youtube_download_options = {
            'format': 'bestvideo+bestaudio/best',
            'outtmpl': os.path.join(download_folder, "Video Downloader", '%(title)s.%(ext)s')
        }
    elif option1 and option2:
        youtube_download_options = {
            'format': 'bestvideo+bestaudio/best',
            'postprocessors': [{
                'key': 'FFmpegExtractAudio',
                'preferredcodec': 'mp3', # you can change the codec to 'wav', 'm4a', etc. as needed
                'preferredquality': 'best', # you can change the audio quality as needed
            }],
            'outtmpl': os.path.join(download_folder, "Video Downloader", '%(title)s.%(ext)s')
        }
    if not option1 and not option2:
        youtube_download_options = {'outtmpl': os.path.join(download_folder, "Video Downloader", '%(title)s.%(ext)s')}
    

    youtube_downloader = yt_dlp.YoutubeDL(youtube_download_options)
    try:
        youtube_downloader.download([saved_text])
        start_ticks = pygame.time.get_ticks()
        background_colour = GREEN
        while True:
            if pygame.time.get_ticks() - start_ticks >=2000:
                background_colour = LIGHT_GREY
                break
    except:
        start_ticks = pygame.time.get_ticks()
        background_colour = RED
        while True:
            if pygame.time.get_ticks() - start_ticks >=2000:
                background_colour = LIGHT_GREY
                break


# Main game loop
running = True
while running:
    screen.fill(background_colour)

    # Handle events
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
        elif event.type == pygame.MOUSEBUTTONDOWN:
            # Check if the input box is clicked
            if 50 <= event.pos[0] <= 350 and 50 <= event.pos[1] <= 50 + inputBoxHeight:
                input_box_active = True
            else:
                input_box_active = False
            # Submit the value using button
            if 150 <= event.pos[0] <= 250 and submitButtonY <= event.pos[1] <= submitButtonY + 50:
                saved_text = input_text
                input_text = ""
                # Download in background
                threading.Thread(target=download).start()
            # Item checkbox 1 -> just audio
            if 170 <= event.pos[0] <= 190 and submitButtonY + 60 <= event.pos[1] <= submitButtonY + 80:
                # Flip values
                if option1 == False:
                    option1 = True
                else:
                    option1 = False
            # Item checkbox 2 -> best quality
            if 210 <= event.pos[0] <= 230 and submitButtonY + 60 <= event.pos[1] <= submitButtonY + 80:
                # Flip values
                if option2 == False:
                    option2 = True
                else:
                    option2 = False
        elif event.type == pygame.KEYDOWN:
            if input_box_active:
                if event.key == pygame.K_BACKSPACE:
                    input_text = input_text[:-1]
                    # Set the time when backspace key was pressed
                    backspace_pressed_time = pygame.time.get_ticks()
                    backspace_repeat_time = backspace_pressed_time + BACKSPACE_DELAY
                    if backspace_pressed_time - backspace_repeat_time > 0:
                        input_text = input_text[:-1]  # Remove a single character
                # Submit the value using ENTER key
                elif event.key == pygame.K_RETURN:
                    saved_text = input_text
                    input_text = ""
                    # Download in background
                    threading.Thread(target=download).start()
                elif event.key == pygame.K_v and pygame.key.get_mods() & pygame.KMOD_CTRL:
                    # Handle Ctrl+V for pasting from clipboard
                    clipboard_text = paste_from_clipboard()
                    input_text += clipboard_text
                else:
                    input_text += event.unicode
    
    if len(input_text) > 80:
        input_text = input_text[:80]

    # Repeatedly remove characters
    if pygame.key.get_pressed()[pygame.K_BACKSPACE]:
        current_time = pygame.time.get_ticks()
        if current_time - backspace_repeat_time > 0:
            input_text = input_text[:-1]  # Remove a single character
            backspace_repeat_time = current_time + BACKSPACE_REPEAT_INTERVAL
    

    inputBoxHeight, submitButtonY = change_input_box_height(input_text, 55, 75, 300)

    # Draw input box and button
    draw_input_box()
    draw_button()
    draw_options_checkboxes()

    # Display input text
    lines_of_text = display_text(input_text, 55, 75, 300)

    # Draw cursor if input box is active and move to end of last line
    if input_box_active and pygame.time.get_ticks() % 1000 < 500:
        cursor_x = font.size(lines_of_text[-1])[0] + 55
        # Start y and end y will increment even on the first line
        # Both have been taken away 50 from
        start_y = 10
        end_y = 40
        for each_line in lines_of_text:
            start_y += 50
            end_y += 50
        pygame.draw.line(screen, BLACK, (cursor_x, start_y), (cursor_x, end_y), 2)

    # Update the display
    pygame.display.flip()


# Quit pygame
pygame.quit()